//
//
//Copyright (c) 2004 Option International NV
//
//Module Name:
//  
//Abstract:
//    This module contains the definition of the broadcom interface
//
//Revision History:
//    Who         When        What
//    --------    --------    ----------------------------------------------
//    Matt Sykes  18-11-04    created
//
//Notes:
//
//

#pragma once




//
// used by the protocol driver, '\\.\GtProt'
//
#define	IOCTL_GT_NDIS_PROT_ATTATCH_TO_NIC		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xB04 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_PROT_QUERY_OID			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xB05 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_PROT_SET_OID				CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xB06 , METHOD_BUFFERED, FILE_ANY_ACCESS)




//
// Used by the various NDIS GPRS drivers, Ricola, GTi, Chilli   '\\.\GtNdis0'
//

#define	MAX_CONNECT_STRING_LENGTH	256

#define IOCTL_GT_NDIS_GPRS_CONNECT				CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80B,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_DISCONNECT			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80C,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_QUERY_STATUS			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80D,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_QUERY_STATS			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80E,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_GPRS_QUERY_IP_INFO	CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0x80F,METHOD_BUFFERED,FILE_ANY_ACCESS)


#define	IOCTL_GT_NDIS_GPRS_RAW_AT				CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA00 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_CANCEL_RX			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA01 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_WRITE_CONFIGDATA		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA02 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_READ_CONFIGDATA		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA03 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_GETORSET_CONNECT_CONFIG	CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA04 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_TRACE				CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA05 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define	IOCTL_GT_NDIS_GPRS_STOP_TRACE			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA06 , METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GT_NDIS_GPRS_SET_TRACE_MASK		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA07 , METHOD_BUFFERED, FILE_ANY_ACCESS)


// currently unused
//#define IOCTL_GT_NDIS_GPRS_GET_IP_ADDRESSES		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA08 , METHOD_BUFFERED, FILE_ANY_ACCESS)
//#define IOCTL_GT_NDIS_GPRS_GO_CONNECTED			CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA09 , METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GT_NDIS_GPRS_GET_NET_CFG_ID		CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA10 , METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GT_NDIS_GPRS_SET_TCPWINDOWSIZE	CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA11 , METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GT_NDIS_GPRS_GET_MAJOR_VERSION 	CTL_CODE(FILE_DEVICE_SERIAL_PORT, 0xA12 , METHOD_BUFFERED, FILE_ANY_ACCESS)





#pragma pack(1)

typedef struct _GT_NDISGPRSIpAddr
{
	UCHAR a;
	UCHAR b;
	UCHAR c;
	UCHAR d;
} GT_NDISGPRSIpAddr;


#define GT_NDIS_GPRS_OPTION_SPECIFICIPADDR		0x00000002
#define GT_NDIS_GPRS_OPTION_SPECIFICDNS			0x00000004

// not used, the card determines compression
//#define GT_NDIS_GPRS_OPTION_HEADERCOMPRESSION	0x00000008
//#define GT_NDIS_GPRS_OPTION_DATACOMPRESSION		0x00000200


#define GT_NDIS_GPRS_MAXLEN_PHONENUMBER		129
#define GT_NDIS_GPRS_MAXLEN_USERNAME		40
#define GT_NDIS_GPRS_MAXLEN_PASSWORD		40
#define GT_NDIS_GPRS_MAXLEN_GUID			48



typedef struct _GT_NDISGPRSConnectParam
{
	UCHAR PhoneNumber[GT_NDIS_GPRS_MAXLEN_PHONENUMBER];
	UCHAR UserName[GT_NDIS_GPRS_MAXLEN_USERNAME];
	UCHAR Password[GT_NDIS_GPRS_MAXLEN_PASSWORD];
	ULONG Options;
	GT_NDISGPRSIpAddr IpAddr;
	GT_NDISGPRSIpAddr IpAddrDns;
	GT_NDISGPRSIpAddr IpAddrDnsAlt;
} GT_NDISGPRSConnectParam;

// GPRS connection status 
typedef enum
{
	GT_NDIS_GPRS_DISCONNECTED,			// Connection disconnected 
	GT_NDIS_GPRS_CONNECTED,				// Connection established 
	GT_NDIS_GPRS_CONNECT_OPEN,			// Port successfully openned 
	GT_NDIS_GPRS_CONNECT_DEVICE,		// Link connected (ATD/CONNECT) 
	GT_NDIS_GPRS_CONNECT_AUTHENTICATING,// Starting authentication 
	GT_NDIS_GPRS_CONNECT_AUTHENTICATED,	// Authentication successfull 
	GT_NDIS_GPRS_DISCONNECTING,			// Starting disconnect 
	GT_NDIS_GPRS_ERROR,					// Error during establishment 
	GT_NDIS_GPRS_UNKNOWN
} GT_NDISGPRSStatusCode;

// GPRS connection reason 
typedef enum
{
	GT_NDIS_GPRS_REASON_UNKNOWN,		// Unknown 
	GT_NDIS_GPRS_REASON_USER_INITIATED,	// User initiated action 
	GT_NDIS_GPRS_REASON_CARRIER_LOST,	// Carrier lost during connection 
	GT_NDIS_GPRS_REASON_LCP_FAILED,		// LCP config failed 
	GT_NDIS_GPRS_REASON_PAP_FAILED,		// PAP Authentication failed 
	GT_NDIS_GPRS_REASON_IPCP_FAILED,	// IPCP failed 
	GT_NDIS_GPRS_REASON_NO_CARRIER,		// No Carrier during setup 
	GT_NDIS_GPRS_REASON_CME_ERROR		// CME Error code, must be last entry in list 
} GT_NDISGPRSReasonCode;

typedef struct _GT_NDISGPRSStatus
{
	GT_NDISGPRSStatusCode		Status;
	GT_NDISGPRSReasonCode		Reason;
} GT_NDISGPRSStatus;

// GPRS connection statistics 
typedef struct _GT_NDISGPRSStats
{
	ULONG BytesXmited;
	ULONG BytesRcved;
	ULONG FramesXmited;
	ULONG FramesRcved;
	ULONG Errors;
	ULONG ConnectDuration;		// milliseconds 
} GT_NDISGPRSStats;



typedef struct _FileFmt
{
	UCHAR Phonenumber[GT_NDIS_GPRS_MAXLEN_PHONENUMBER];
	UCHAR Username[GT_NDIS_GPRS_MAXLEN_USERNAME];
	UCHAR Password[GT_NDIS_GPRS_MAXLEN_PASSWORD];
	ULONG ClientIpAddress;
	ULONG DNS1Address;
	ULONG DNS2Address;
}FileFmt, *PFileFmt;



typedef struct _ConnectionStrings
{
	UCHAR					ConfigString1[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString2[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString3[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString4[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString5[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString6[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConfigString7[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString1[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString2[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString3[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString4[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString5[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString6[MAX_CONNECT_STRING_LENGTH];
	UCHAR					ConnectString7[MAX_CONNECT_STRING_LENGTH];
	ULONG					Secret;
}ConnectionStrings, *PConnectionStrings;



typedef struct _ConfigData
{
	GT_NDISGPRSConnectParam		ConnectionParam;
	ConnectionStrings			ConectionStrings;
}ConfigData, *PConfigData;



typedef struct _IpAddressInfo
{
	UCHAR name[MAX_CONNECT_STRING_LENGTH];
	ULONG IpAddress1;
	ULONG IpAddress2;
	ULONG IpAddress3;
	ULONG IpAddress4;
	ULONG IpAddress5;
	ULONG IpAddress6;
	ULONG SubnetMask;
	ULONG DNSAddress1;
	ULONG DNSAddress2;
	ULONG GateWayAddress;
}IpAddressInfo, *PIpAddressInfo;